package com.agilex.healthcare.directscheduling.mdws.translator;

import java.util.Date;

import com.agilex.healthcare.directscheduling.domain.CancelAppointment;
import com.agilex.healthcare.directscheduling.domain.CancelAppointmentEmail;
import com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.CancelAppointmentTO;
import com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.HospitalLocationTO;
import com.agilex.healthcare.directscheduling.mdws.generatedwsdl.schedulingservice.SiteTO;
import com.agilex.healthcare.directscheduling.utils.DateHelper;
import com.agilex.healthcare.directscheduling.validator.MdwsResponseException;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;
import com.agilex.healthcare.utility.NullChecker;

public class CancelAppointmentTranslator {

    public CancelAppointment translate(CancelAppointmentTO cancelAppointmentTO, String siteCode){
    	if (cancelAppointmentTO == null)
    		throw new MdwsResponseException(MdwsResponseException.UserMessages.INVALID_DATA_RETURNED, "CancelAppointmentTO was null");
    	if (cancelAppointmentTO.getFault() != null)
    		throw new MdwsResponseException(cancelAppointmentTO.getFault());

    	HospitalLocationTO clinic = cancelAppointmentTO.getClinic();
    	String timestamp = cancelAppointmentTO.getTimestamp();
		String purpose = cancelAppointmentTO.getPurpose();
		String reason = cancelAppointmentTO.getReason();
		String remarks = cancelAppointmentTO.getRemarks();
		
    	CancelAppointmentEmail cancelAppointment = new CancelAppointmentEmail();
    	if (clinic != null) {
    		//Perform Error Checking
    		if (clinic.getFault() != null)
        		throw new MdwsResponseException(clinic.getFault());
	    	String id = clinic.getId();
			cancelAppointment.setClinicId(id);
			cancelAppointment.setFacility(setFacility(siteCode));
    	}
    	
        if(NullChecker.isNotNullish(timestamp)) {
			Date dt = DateHelper.parseVistaDateTime(timestamp);
			cancelAppointment.setAppointmentTime(dt);
		}
        
        cancelAppointment.setCancelCode(purpose);
        cancelAppointment.setCancelReason(reason);
        cancelAppointment.setRemarks(remarks);

        return cancelAppointment;
    }
   
    private Facility setFacility(String siteCode){
    	Facility facility = new Facility();
    	facility.setFacilityCode(siteCode);
    	return facility;
    }    
}